%% Function to create grids from obj polygos - G.A. Jun 2009 / ARUPLIGHTING
% Current version: v.1.0.4
% What's new: v 1.0.4 some minor touches to the error report (see ERROR:...)
% What's new: v 1.0.3 added swap switch for c4d coordinates (XZY - > XYZ)
% What's new: v 1.0.3 added check for zero points
% What's new: v 1.0.2 added offset of normal
% What's new: v 1.0.1 added pass instead of number of points and corrected various bugs
% mind that swapping of Z - Y is performed in the function load_obj_quads_c4d
% if you need to change this behavious edit lines 197 and 199 in file load_obj_quads_c4d

function grigliata(file,pass_i,pass_j)
disp('USAGE: grigliata(''name of the file.obj'',pass i  in world units, pass j in world units)');
disp('REMEMBER: grigliata requires that:');
disp('* obj file contains materials');
disp('* ALL vertex should be used in polygons (so no orphan vertexes)');
disp('* ONLY rectangles are supported');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Mind you need an obj containing quads and planar!
%also sides need to be PARALLEL! Rectangles please///

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Cinema4d swapping
c4d = 1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


unix('mkdir grids');
unix('echo Did you check is a rectangle? > grids/summary.txt');
%load obj and switch to 4 vertexes selection and cinema axys orientation
vertex =4;
[PP,QQ, E]=load_obj_quads_c4d(file,vertex,c4d);

%how many grids?
n_grids = size(QQ,1)/4;

%cycle for each grid
for i = 1 : n_grids

% get starting coordinates for grid
starting_point =  QQ(4*(i-1)+1,1:3);
second_point =    QQ(4*(i-1)+2,1:3);
opposite_corner = QQ(4*(i-1)+3,1:3);
last_point =      QQ(4*(i-1)+4,1:3);

divisions_i = floor(norm(second_point - starting_point)/pass_i);
divisions_j = floor(norm(last_point   - starting_point)/pass_j);

if( divisions_i < 1)
disp('ERROR: Reduce i pass, too big!'); 
if( divisions_j < 1)
disp('ERROR: Reduce j pass, too big!'); break;
end
break;
end

if( divisions_j < 1)
disp('ERROR: Reduce j pass, too big!'); break;
end

disp(sprintf('The grid is: %d by %d points.',divisions_i,divisions_j));

%fill an ampty matrix
grid_points = zeros((divisions_i-1)*(divisions_j-1),3);



% generates versors for grid
versore_i = pass_i * (second_point - starting_point) /norm(second_point - starting_point);
versore_j = pass_j * (last_point   - starting_point) /norm(last_point   - starting_point);



delta_i = ((second_point - starting_point) - pass_i * (second_point - starting_point) /norm(second_point - starting_point)*(divisions_i-1) )/2 ;

delta_j = ((last_point   - starting_point) - pass_j * (last_point   - starting_point) /norm(last_point   - starting_point)*(divisions_j-1) )/2; 



% generate normal and spray over grid
N = (cross(versore_i,versore_j)) / norm(cross(versore_i,versore_j));
normals = repmat(N,(divisions_i-1)*(divisions_j-1),1);


safety_delta = N * 0.01;



% permute all point is grid
for vi = 1:divisions_i-1
for vj = 1:divisions_j-1
grid_points((vi-1)*(divisions_j-1)+vj,1:3) = safety_delta + delta_i+delta_j+starting_point+(versore_i/2+versore_j/2)+(versore_i*(vi-1))+(versore_j*(vj-1));
end
end


% assembre final matrix with all points and normals
grid_points = [grid_points normals];

% save output grid
save -ascii grid.tmp grid_points;
unix(sprintf('mv grid.tmp grids/grids_%.3d.grd',i));


% update the summary file
disp(sprintf('Grid: %.3d; punti_i= %d; punti_j= %d;  v_i= %f %f %f; v_j: %f %f %f; N= %d %d %d;',i,divisions_i-1,divisions_j-1,versore_i,versore_j,N(1,1),N(1,2),N(1,3) ));
unix(sprintf('echo "Grid: %.3d; punti_i= %d; punti_j= %d;  v_i= %f %f %f; v_j: %f %f %f; N= %.2f %.2f %.2f;" >> grids/summary.txt',i,divisions_i-1,divisions_j-1,versore_i,versore_j,N(1,1),N(1,2),N(1,3) ));
end

if( divisions_i >= 1) && ( divisions_j >= 1)
disp('Grids all converted into Radiance input files. Look for ''grids'' folder')
end

end
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%










%% Function to import an obj - G.A. Jun 2009 / ARUPLIGHTING
% swithch to export also quads - for grid generation
% Current version: v.1.0.4
% What's new: Obj importer accepts rhino obj with UV in 2D                v.1.0.4
% What's new: Obj also requires the c4d flag to swap coordinates 1 = yes  v.1.0.4
% What's new: Obj importer is adapted for gridify and obj2odx. v.1.0.3
% What's new: Obj importer with now reporting error if obj file is not there. v.1.0.1
% Heavily based on previous work by:
% W.S. Harwin, University Reading, 2006
% See also Anders Sandberg's vertface2obj.m and saveobjmesh.m
% This modified version exports vertex coordinates and UV coordinates for triangles.


function [PP,QQ, E]=load_obj_quads_c4d(file,vertex,c4d)
%file = 'test.obj';
%vertex =4;



if nargin <1 
  disp('specify model name')  
end


V = [];
VT = [];

F3v = [];
F3t = [];

F4v = [];
F4t = [];
%%
% Output is:
%
% * VT, coorfinate for textures
% * V, coordinate for vertex
% * F3v, connections for triangles
% * F4t, connections for UV triangles
% * F4v, connection for quads
% * F4t, connection for UV quads
%
% 

%%
% open and scan the file with format and get cell array with the 13 values
%file = 'testUV2.obj';
fid = fopen(file,'r');
if (fid<0) error(['Can not open the .obj file: ' file]);end


%%
% define some counters
vnum=1;
f3num=1;
f4num=1;
vtnum=1;
vnum=1;
gnum=1;

%%
% Scan lines which are not empty
cline=fgets(fid);
while cline>=0
  cline = deblank(cline);
  cline = deblank(cline);
  cline = deblank(cline);
  s = sscanf(cline,'%s',1);
  l=length(cline);
  if l==0  
%%
% Line is  empty 
    %disp(['empty' cline]);
  end

%%
% if the line is not empty start reading file for different cases:
    switch s
%%
% These are comments
    case '#' 
        %disp(['Skipping: ' cline]);
%%
% These are vertexes and are collected into V
      case 'v' 
          v=sscanf(cline(2:l),'%f');      
          V(:,vnum)=v;      
          vnum=vnum+1;
%%
% textures
      case 'vt' 
%%
% scan from char 3 to L, end of line
         vt=sscanf(cline(3:l),'%f');      
         VT(:,vtnum)=vt;      
         vtnum=vtnum+1;
%%       
% mesh or nurbs, just ignore
      case 'g'       
            %disp(['Skipping: ' cline]);
%%
% Material of object, this need improvement
%%
% *NOTE: NOW ALL WORKS ONLY WITH ONLY ONE MATERIAL*
      case 'usemtl' 
            %disp(['Skipping: ' cline]);
%%
% Normals - ignored
        case 'vn'      
    %disp(['Skipping: ' cline]);
        
%%
% Faces
        case 'f' 
%%
% remove trailing zeros
      cline=deblank(cline(3:l));
%%
% count spaces, add one = vertexes
      nvrts=length(findstr(cline,' '))+1;
%%
% count slashes
      fstr=findstr(cline,'/');
      nslash=length(fstr);

      if nvrts == 3
%%
% Case with vertex and textures
         if nslash ==3
%%
% scan for vertex
             f1=sscanf(cline,'%f/%f');
          f1=f1([1 3 5]);
%%
% scan for UV vertex
          f2=sscanf(cline,'%f/%f');
          f2=f2([2 4 6]);
%%
% case with vertex, textures and normals,
        elseif nslash==6  
          f1=sscanf(cline,'%f/%f/%f');
          f1=f1([1 4 7]);
          f2=sscanf(cline,'%f/%f/%f');         
          f2=f2([2 5 8]);
         elseif nslash==0
          f1=sscanf(cline,'%f');
        else
          %disp(['xyx' cline])
          f1=[];
          f2=[];
         end
%%
% The output for vertex connections
        F3v(:,f3num)=f1;
        F3t(:,f3num)=f2;
        f3num=f3num+1;
      
      
%%
% Same but for quads, which are not supported by the Radiance
% interface
      elseif nvrts == 4
        if nslash == 4
          f1=sscanf(cline,'%f/%f');
          f1=f1([1 3 5 7]);
          f2=sscanf(cline,'%f/%f');
          f2=f2([2 4 5 8]);
        elseif nslash == 8
          f1=sscanf(cline,'%f/%f/%f');
          f1=f1([1 4 7 10]);
          f2=sscanf(cline,'%f/%f/%f');
          f2=f2([2 6 8 11]);
        elseif nslash ==0
          f1=sscanf(cline,'%f');
        else
          %disp(['xx' cline])
          f1=[];
          f2=[];
        end
        F4v(:,f4num)=f1;
        F4t(:,f4num)=f2;
        f4num=f4num+1;
      end 
     
    otherwise 
      if ~strcmp(cline,char([13 10]))
        %disp(['Unprocessed: ' cline]);
      end
    end
     
       cline=fgets(fid);
end

fclose(fid);


if(c4d == 1)
%cinema 4d and swap of axes
PER = [1 0 0; 0 0 -1; 0 1 0];
disp('Swapping coordinates Z-Y. Cinema4D ready.')
end

if(c4d == 0)
%standard axis
PER = [1 0 0; 0 1 0; 0 0 1];
disp('Coordinates unchanged. No Z-Y swapping.')
end


%this fixes when textures have just x y and not z coordinates...
%bloody rhino...
if(size(VT,1) == 2)
VT(3,:) = 0;
end

PP_4 = VT(1:3,F4t)';
QQ0_4 = V(1:3,F4v)';
QQ1_4 = PER*QQ0_4';
QQ_4 = QQ1_4';

PP_3 = VT(1:3,F3t)';
QQ0_3 = V(1:3,F3v)';
QQ1_3 = PER*QQ0_3';
QQ_3 = QQ1_3';

if (vertex == 4)
PP = PP_4;
QQ=QQ_4;
end


if (vertex == 3)
PP = PP_3;
QQ=QQ_3;
end



E = 0;
if (isempty(PP)==1) 
E = 1;
end

end

